# 📦 DeepCamera 2x Super Resolution

A command-line interface (CLI) tool to perform 2x super-resolution on YUV video files using a remote inference server.

---

## 🚀 Usage

```bash
python your_script.py [OPTIONS]
```

---

## 🔧 Arguments

| Argument         | Short | Required | Description                                                                                                                          |
| ---------------- | ----- | -------- | ------------------------------------------------------------------------------------------------------------------------------------ |
| `--input_file`   | `-i`  | ✅ Yes    | Path to the **input YUV video** file to be processed.                                                                                |
| `--output_file`  | `-o`  | ✅ Yes    | Path where the **upsampled output** video will be saved.                                                                             |
| `--url`          | `-u`  | ✅ Yes    | URL of the **inference server** (`https://mpai-ufv.cyens.org.cy/`).                                                                       |
| `--size`         |       | ✅ Yes    | Input video resolution (e.g., `720p`, `1080p`).                                                                                      |
| `--pixel_format` |       | ✅ Yes    | YUV pixel format. See supported formats here: [labradon/yuvio](https://github.com/labradon/yuvio).                                   |
| `--model`        |       | ❌ No     | Which model to use for upscaling. Options:<br>• `hd24k_full`<br>• `hd24k_standard` (default)<br>• `sd2hd_full`<br>• `sd2hd_standard` |

---

## 🧪 Example

```bash
python main.py -i input_video.yuv -o output_video.yuv -u https://mpai-ufv.cyens.org.cy/ --size 1080p --pixel_format yuv420p10le --model hd24k_standard
```

---

## 📝 Notes

* The input video must be a **raw YUV** file with the specified resolution and pixel format.
* Make sure the remote inference server is running and accessible via the `--url` you provide.
* This tool does **not read/write MP4 or other container formats** — it operates directly on raw video frames.
